import pandas as pd
from matplotlib import pyplot as plt

plt.style.use("seaborn")

data = pd.read_csv("data.csv")
ages = data['Age']
dev_salaries = data['All_Devs']
py_salaries = data['Python']
js_salaries = data['JavaScript']

# fig is a container holding out plots,
# ax - or axes is out plots (default 1x1)
# fig, ax = plt.subplots()

# ax.plot(ages, py_salaries, label="Python")
# ax.plot(ages, js_salaries, label="JavaScript")
# ax.plot(ages, dev_salaries, color="#444444",
#             linestyle="--", label="All Devs")

# ax.legend()

# ax.set_title("Median Salary (USD) by Age")
# ax.set_xlabel("Ages")
# ax.set_ylabel("Median salary (USD)")

# plt.tight_layout()
# plt.show()

# fig, ax = plt.subplots(nrows=2, ncols=1)
# print(ax)

# or better, unpack
fig, (ax1, ax2) = plt.subplots(nrows=2, ncols=1, sharex=True, sharey=True)

ax1.plot(ages, py_salaries, label="Python")


ax1.set_title("Median Salary (USD) by Age")
ax1.set_xlabel("Ages")
ax1.set_ylabel("Median Python salary (USD)")
ax1.legend()

ax2.plot(ages, js_salaries, label="JavaScript")
ax2.plot(ages, dev_salaries, color="#444444",
            linestyle="--", label="All Devs")

ax2.legend()

ax2.set_title("Median Salary (USD) by Age")
ax2.set_xlabel("Ages")
ax2.set_ylabel("Median JS/All salary (USD)")
ax2.legend()

plt.tight_layout()
plt.show()
